<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Skill extends Model 
{

    protected $table = 'skills';
    public $timestamps = true;
    protected $fillable = array('sub_category_id', 'name');

    public function subCategory()
    {
        return $this->belongsTo('App\Models\SubCategory', 'sub_category_id');
    }

    public function student()
    {
        return $this->belongsToMany('App\Models\Student', 'student_skill');
    }

}